/**********************************************************
 *(c) by Knobloch GmbH
 *       Weedgasse 14 
 *       D-55234 Erbes-Bdesheim                                    
 *
 *  Headerdatei:    TAF_00P.h   Headerfile for Robo-Interface C-Compiler
 *                              Section: TransferArea and Firmware 
 *                              Typ:     Function Prototypes
 *
 *  Version:        0.62
 *
 *  Revisionen: 
 *          0.01:   21.11.2005
 *                  Start
 *          0.60:   08.02.2005
 *                  - TimerTick1ms()
 *          0.62:   11.03.2006
 *                  - Changing SendFtMessage()
 *          0.65:   12.05.2006
 *                  - Changing ClearFtMessagePuffer() --> ClearFtMessageBuffer()
 **********************************************************/


/**** Header Dateien ***************************************/


#ifndef TAF_00_P
    #define TAF_00_P

    // Firmwarefunction "SetFtDeviceReset()"
    static void SetFtDeviceReset(char);
    #pragma     __ASMMACRO SetFtDeviceReset(R1L)
    #pragma ASM
        _SetFtDeviceReset    .macro
        JSRS        #20
        .endm
    #pragma ENDASM
    #define     COLD_BOOT       0       // #0 = Interface COLD-BOOT (delete RAM)
    #define     WARM_BOOT       1       // #1 = Interface WARM-BOOT


    // Firmwarefunction "SetFt1msTimerTickAddress()"
    // SetFt1msTimerTickAddress(NULL) = stop calling TimerTickFunction
    static void SetFt1msTimerTickAddress(void far *() );
    #pragma     __ASMMACRO SetFt1msTimerTickAddress(A1A0)
    #pragma ASM
        _SetFt1msTimerTickAddress .macro
        PUSH.W      A1
        PUSH.W      A0
        JSRS        #21
        add.b       #4h,sp
        .endm
    #pragma ENDASM



    // Firmwarefunction "SetFtDeviceCommMode()"
    static void SetFtDeviceCommMode(UCHAR, UCHAR, UINT _far *);
    #pragma     __ASMMACRO SetFtDeviceCommMode(R1L, R1H, A1A0)
    #pragma ASM
        _SetFtDeviceCommMode    .macro
        PUSH.W      A1
        PUSH.W      A0
        PUSH.B      R1H
        JSRS        #22
        add.b       #5h,sp
        .endm
    #pragma ENDASM                                  // COM-Modes for SetFtDeviceCommMode()
    #define     IF_COM_ONLINE               1       // Online Mode
    #define     IF_COM_MESSAGE              3       // Messagemode
    #define     IF_COM_PARAMETER            5       // Get Mode



    // Firmwarefunction "GetFtRfParameter()"
    static UCHAR GetFtRfParameter(UCHAR _far *);
    #pragma     __ASMMACRO GetFtRfParameter(A1A0)
    #pragma ASM
        _GetFtRfParameter .macro
        PUSH.W      A1
        PUSH.W      A0
        JSRS        #23
        add.b       #4h,sp
        .endm
    #pragma ENDASM



    // Firmwarefunction "ClearFtMessagePuffer()"
    static void ClearFtMessageBuffer(void);
    #pragma     __ASMMACRO ClearFtMessageBuffer()
    #pragma ASM
        _ClearFtMessageBuffer   .macro
        JSRS        #25
        .endm
    #pragma ENDASM



    // Firmwarefunction "SetFtMessageReceiveAddress()"
    static void SetFtMessageReceiveAddress(void *() );
    #pragma     __ASMMACRO SetFtMessageReceiveAddress(A1A0)
    #pragma ASM
        _SetFtMessageReceiveAddress .macro
        PUSH.W      A1
        PUSH.W      A0
        JSRS        #26
        add.b       #4h,sp
        .endm
    #pragma ENDASM



    // Firmwarefunction "SendFtMessage()"
    static UCHAR SendFtMessage(UCHAR, UCHAR, ULONG, UINT, UINT);
    #pragma     __ASMMACRO SendFtMessage(R1L, R1H, A1A0, R0, R2)
    #pragma ASM
        _SendFtMessage  .macro
        PUSH.W      R2
        PUSH.W      R0
        PUSH.W      A1
        PUSH.W      A0
        PUSH.B      R1H
        JSRS        #27
        add.b       #7h,sp
        .endm
    #pragma ENDASM                                  // Message-System

    #define     MSG_HWID_SELF               0       // Message for himself
    #define     MSG_HWID_SER                1       // Message for the Robo-Interface serial port
    #define     MSG_HWID_RF                 2       // Message for other Interfaces (over RF)
    #define     MSG_HWID_RF_SELF            3       // Message for other Interfaces (over RF) and for himself (back over RF)

    #define     MSG_SEND_NORMAL             0       // Message send "normal"
    #define     MSG_SEND_OTHER_THAN_LAST    1       // Message send "if not the same as the last message"
    #define     MSG_SEND_IF_NOT_PRESENT     2       // Message send "if not present in the send buffer"


    // Error-Messages
    #define     ERROR_SUCCESS                       0       // No Error
    #define     FTLIB_ERR_MSG_BUFFER_FULL_TIMEOUT   0xCF    // MESSAGE-Error: Puffer voll
    #define     ERROR_WRONG_OPTION                  0xE4    // Message-Error: Wrong Value in "uiOption"



    // Firmwarefunction "FtDelay()"
    static void FtDelay(UINT);
    #pragma     __ASMMACRO FtDelay(R1)
    #pragma ASM
        _FtDelay    .macro
        JSRS        #30
        .endm
    #pragma ENDASM




    // Firmwarefunction "SetFtDistanceSensorMode()"
    void SetFtDistanceSensorMode(UCHAR, UCHAR, UCHAR, UINT, UINT, UCHAR, UCHAR);
    #define     IF_DS_INPUT_VOLTAGE         0       // Voltage
    #define     IF_DS_INPUT_DISTANCE        1       // Distance
    #define     IF_DS_INPUT_TOL_STD         20      // Toleranz (Standard)
    #define     IF_DS_INPUT_REP_STD         3       // Repeat (Standard)

#endif


// End of File